﻿<%@ Page Language="c#" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ import Namespace="System.Collections.Generic" %>

<script runat="server">

    static string empty = "<b>BRAK</b>";
	 
    class Pozycja {
        string blok;
        public string Blok {
            get { return blok; }
            set { blok = value; }
        }
        string pole;
        public string Pole {
            get { return pole; }
            set { pole = value; }
        }
        string numer;
        public string Numer {
            get { return numer; }
            set { numer = value; }
        }
        string wartosc;
        public string Wartosc {
            get { return wartosc; }
            set { wartosc = value; }
        }
        string tytul;
        public string Tytul {
            get { return tytul; }
            set { tytul = value; }
        }
        string opis;
        public string Opis {
            get { return opis; }
            set { opis = value; }
        }
        bool wymagane;
        public bool Wymagane {
            get { return wymagane; }
            set { wymagane = value; }
        }
        public Pozycja(string blok, string tytul, string pole, string numer, string opis, bool wymagane) {
            this.blok = blok;
            this.tytul = tytul;
            this.pole = pole;
            this.numer = numer;
            this.opis = opis;
            this.wymagane = wymagane;
        }
        public Pozycja(string blok, string tytul, string pole, string numer, string opis, string wartosc, bool wymagane) {
            this.blok = blok;
            this.tytul = tytul;
            this.pole = pole;
            this.numer = numer;
            this.opis = opis;
            Przypisz(wartosc);
        }
        public bool Porownaj(string blok, string pole) {
            return (this.blok == blok && this.pole == pole);
        }
        public void Przypisz(string wartosc) {
            if (wymagane)
                this.wartosc = (wartosc.Length != 0) ? wartosc : empty;
            else
                this.wartosc = wartosc;
        }
    }

    public class Params : ContextBase {
        public Params(Context context) : base(context) {
        }

        bool braki;
        [Caption("Pokaż tylko braki")]
        public bool Braki {
            get { return braki; }
            set {
                braki = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    Params pars;
    [Context]
    public Params Pars {
        set { pars = value; }
    }

    class DeklaracjaComparer : IComparer {
        public int Compare(object ox, object oy) {
            string x = ox.GetType().ToString();
            string y = oy.GetType().ToString();
            return x.CompareTo(y);
        }
    }

    bool SprawdzTyp(Deklaracja dek) {
        bool result = false;
        
        switch (dek.GetType().ToString()) {
            case "Soneta.Deklaracje.ZUS.ZUA":
            case "Soneta.Deklaracje.ZUS.ZIUA":
            case "Soneta.Deklaracje.ZUS.ZCNA":
            case "Soneta.Deklaracje.ZUS.ZWUA":
            case "Soneta.Deklaracje.ZUS.ZZA":
                result = true;
                break;
        }

        return result;
    }
    
    void OnContextLoad(Object sender, EventArgs e) {
        ArrayList lista = new ArrayList();

        Soneta.Deklaracje.ZUS.KEDU kedu = (Soneta.Deklaracje.ZUS.KEDU)dc[typeof(Soneta.Deklaracje.ZUS.KEDU)];
        foreach (Deklaracja dek in kedu.Deklaracje)
            if (SprawdzTyp(dek))
                lista.Add(dek);
        lista.Sort(new DeklaracjaComparer());

        DataRepeater1.DataSource = lista;
    }

    protected void DataRepeater1_BeforeRow(object sender, EventArgs e) {
        Deklaracja dek = (Deklaracja)DataRepeater1.CurrentRow;
        
        switch (dek.GetType().ToString()) {
            case "Soneta.Deklaracje.ZUS.ZUA":
                DekZUA(dek);
                break;
            case "Soneta.Deklaracje.ZUS.ZIUA":
                DekZIUA(dek);
                break;
            case "Soneta.Deklaracje.ZUS.ZCNA":
                DekZCNA(dek);
                break;
            case "Soneta.Deklaracje.ZUS.ZWUA":
                DekZWUA(dek);
                break;
            case "Soneta.Deklaracje.ZUS.ZZA":
                DekZZA(dek);
                break;
        }
    }

    void DekZCNA(Deklaracja dek) {
        Soneta.Deklaracje.ZUS.ZCNA zcna = (Soneta.Deklaracje.ZUS.ZCNA)dek;
        Symbol.EditValue = "ZCNA";
        Pracownik.EditValue = zcna.Pracownik;

        List<Pozycja> pozycje = new List<Pozycja>();
        pozycje.Add(new Pozycja("III", "Dane identyfikacyjne osoby ubezpieczonej", "p1", "1", "Numer Pesel", "", true));
        pozycje.Add(new Pozycja("III", "Dane identyfikacyjne osoby ubezpieczonej", "p4", "4", "Numer paszport", "", true));

        string wartosc = "";
        string p31 = "", p34 = "";
        foreach (Soneta.Deklaracje.DefinicjaBloku defBlok in zcna.Bloki)
            foreach (Soneta.Deklaracje.DefinicjaPola defPole in defBlok.Pola)
                foreach (Pozycja pz in pozycje)
                    if (pz.Porownaj(defBlok.XmlTag, defPole.XmlTag)) {
                        wartosc = defPole.GetValue(zcna).ToString();
                        switch (defPole.Typ) {
                            case TypPolaDeklaracji.Bool:
                            case TypPolaDeklaracji.Int:
                                if (wartosc.ToLower() == "true")
                                    wartosc = "TAK";
                                else if (wartosc.ToLower() == "false")
                                    wartosc = "NIE";
                                break;
                        }
                        pz.Przypisz(wartosc);
                        if (pz.Blok == "III" && pz.Numer == "1")
                            p31 = wartosc;
                        else if (pz.Blok == "III" && pz.Numer == "4")
                            p34 = wartosc;
                        break;
                    }

        if (p31.Length > 0 || p34.Length > 0)
            foreach (Pozycja pz in pozycje)
                if (pz.Blok == "III" && (pz.Numer == "1" || pz.Numer == "4") && pz.Wartosc == empty)
                    pz.Wartosc = "";

        int pos = 1;
        string opis = "Dane o członku rodziny osoby ubezpieczonej uprawnionym do świadczeń z ubezpieczenia zdrowotnego";
        bool naliczajZCZA = !DeklaracjeModule.GetInstance(dc).Config.ZUS.Ogólne.NieNaliczajZCZA;
        foreach (CzlonekRodziny osoba in zcna.Pracownik.Rodzina)
            if (osoba.UbezpieczenieOkres != FromTo.Empty && (!osoba.Adres.IsEmpty() || !naliczajZCZA)) {
                string pkt = "IV A (" + (pos++) + ")";
                string p1 = "", p2 = "";
                if (osoba.UbezpieczenieOkres.To == Date.MaxValue) {
                    p1 = "1";
                    p2 = osoba.UbezpieczenieOkres.From.ToString();
                }
                else {
                    p1 = "2";
                    p2 = osoba.UbezpieczenieOkres.To.ToString();
                }
                string p3 = osoba.PESEL;
                string p5 = "", p6 = "";
                if (osoba.Dokument.Rodzaj != 0 && Soneta.Deklaracje.ZUS.DefinicjaDAU.ZapiszNumerDokumentu(osoba, osoba.PESEL)) {
                    p5 = CaptionAttribute.EnumToString(osoba.Dokument.Rodzaj);
                    p6 = osoba.Dokument.SeriaNumer;
                }
                pozycje.Add(new Pozycja(pkt, opis, "p1", "1", "Zgłoszenie/Wyrejestrowanie członka rodziny", p1, true));
                pozycje.Add(new Pozycja(pkt, opis, "p2", "2", "Data uzyskania/utraty uprawnień do ubezpieczenia zdrowotnego przez członka rodziny", p2, false));
                pozycje.Add(new Pozycja(pkt, opis, "p3", "3", "Numer Pesel", p3, p3.Length == 0 && p6.Length == 0));
                pozycje.Add(new Pozycja(pkt, opis, "p4", "4", "Numer NIP", Soneta.Core.Nip.Flat(osoba.NIP), false));
                pozycje.Add(new Pozycja(pkt, opis, "p5", "5", "Rodzaj dokumentu", p5, false));
                pozycje.Add(new Pozycja(pkt, opis, "p6", "6", "Seria i numer dokumentu", p6, p3.Length == 0 && p6.Length == 0));
                pozycje.Add(new Pozycja(pkt, opis, "p7", "7", "Nazwisko", osoba.Nazwisko, true));
                pozycje.Add(new Pozycja(pkt, opis, "p8", "8", "Imię pierwsze", osoba.Imie, true));
                pozycje.Add(new Pozycja(pkt, opis, "p9", "9", "Data urodzenia", osoba.Urodzony.Data.ToString(), true));
                pozycje.Add(new Pozycja(pkt, opis, "p10", "10", "Kod stopnia pokrewieństwa", CaptionAttribute.EnumToString(osoba.StPokrewienstwa), true));
                pozycje.Add(new Pozycja(pkt, opis, "p11", "11", "Wspólne gospodarstwo domowe", (osoba.WspolneGospDomowe ? "TAK" : "NIE"), false));
                pozycje.Add(new Pozycja(pkt, opis, "p12", "12", "Kod stopnia niepełnosprawności", CaptionAttribute.EnumToString(osoba.StNiepelnosprawnosci), false));
            }

        Grid1.DataSource = pozycje;
    }

    void DekZIUA(Deklaracja dek) {
        Soneta.Deklaracje.ZUS.ZIUA ziua = (Soneta.Deklaracje.ZUS.ZIUA)dek;
        Symbol.EditValue = "ZIUA";
        Pracownik.EditValue = ziua.Pracownik;

        List<Pozycja> pozycje = new List<Pozycja>();
        pozycje.Add(new Pozycja("III", "Poprzednie dane identyfikacyjne osoby ubezpieczonej", "p1", "1", "Numer PESEL", true));
        pozycje.Add(new Pozycja("III", "Poprzednie dane identyfikacyjne osoby ubezpieczonej", "p2", "2", "Numer NIP", false));
        pozycje.Add(new Pozycja("III", "Poprzednie dane identyfikacyjne osoby ubezpieczonej", "p3", "3", "Rodzaj dokumentu", false));
        pozycje.Add(new Pozycja("III", "Poprzednie dane identyfikacyjne osoby ubezpieczonej", "p4", "4", "Seria i nr dokumentu", true));
        pozycje.Add(new Pozycja("III", "Poprzednie dane identyfikacyjne osoby ubezpieczonej", "p5", "5", "Nazwisko", true));
        pozycje.Add(new Pozycja("III", "Poprzednie dane identyfikacyjne osoby ubezpieczonej", "p6", "6", "Imię pierwsze", true));
        pozycje.Add(new Pozycja("III", "Poprzednie dane identyfikacyjne osoby ubezpieczonej", "p7", "7", "Data urodzenia", true));
        pozycje.Add(new Pozycja("IV", "Aktualne dane identyfikacyjne osoby ubezpieczonej", "p1", "1", "Numer PESEL", true));
        pozycje.Add(new Pozycja("IV", "Aktualne dane identyfikacyjne osoby ubezpieczonej", "p2", "2", "Numer NIP", false));
        pozycje.Add(new Pozycja("IV", "Aktualne dane identyfikacyjne osoby ubezpieczonej", "p3", "3", "Rodzaj dokumentu", false));
        pozycje.Add(new Pozycja("IV", "Aktualne dane identyfikacyjne osoby ubezpieczonej", "p4", "4", "Seria i nr dokumentu", true));
        pozycje.Add(new Pozycja("IV", "Aktualne dane identyfikacyjne osoby ubezpieczonej", "p5", "5", "Nazwisko", true));
        pozycje.Add(new Pozycja("IV", "Aktualne dane identyfikacyjne osoby ubezpieczonej", "p6", "6", "Imię pierwsze", true));
        pozycje.Add(new Pozycja("IV", "Aktualne dane identyfikacyjne osoby ubezpieczonej", "p7", "7", "Data urodzenia", true));

        string wartosc = "";
        string p31 = "", p34 = "";
        string p41 = "", p44 = "";
        foreach (Soneta.Deklaracje.DefinicjaBloku defBlok in ziua.Bloki)
            foreach (Soneta.Deklaracje.DefinicjaPola defPole in defBlok.Pola)
                foreach (Pozycja pz in pozycje)
                    if (pz.Porownaj(defBlok.XmlTag, defPole.XmlTag)) {
                        wartosc = defPole.GetValue(ziua).ToString();
                        switch (defPole.Typ) {
                            case TypPolaDeklaracji.Bool:
                            case TypPolaDeklaracji.Int:
                                if (wartosc.ToLower() == "true")
                                    wartosc = "TAK";
                                else if (wartosc.ToLower() == "false")
                                    wartosc = "NIE";
                                break;
                        }
                        if (pz.Numer == "3" && wartosc == "0")
                            wartosc = "";
                        pz.Przypisz(wartosc);
                        if (pz.Blok == "III" && pz.Numer == "1")
                            p31 = wartosc;
                        else if (pz.Blok == "III" && pz.Numer == "4")
                            p34 = wartosc;
                        if (pz.Blok == "IV" && pz.Numer == "1")
                            p41 = wartosc;
                        else if (pz.Blok == "IV" && pz.Numer == "4")
                            p44 = wartosc;
                        break;
                    }

        if (p31.Length > 0 || p34.Length > 0)
            foreach (Pozycja pz in pozycje)
                if (pz.Blok == "III" && (pz.Numer == "1" || pz.Numer == "4") && pz.Wartosc == empty)
                    pz.Wartosc = "";
        if (p41.Length > 0 || p44.Length > 0)
            foreach (Pozycja pz in pozycje)
                if (pz.Blok == "IV" && (pz.Numer == "1" || pz.Numer == "4") && pz.Wartosc == empty)
                    pz.Wartosc = "";

        Grid1.DataSource = pozycje;
    }

    void DekZUA(Deklaracja dek) {
        Soneta.Deklaracje.ZUS.ZUA zua = (Soneta.Deklaracje.ZUS.ZUA)dek;
        Symbol.EditValue = "ZUA";
        Pracownik.EditValue = zua.Pracownik;
        
        List<Pozycja> pozycje = new List<Pozycja>();
        pozycje.Add(new Pozycja("III", "Dane identyfikacyjne osoby zgłaszanej do ubezpieczeń", "p1", "1", "Numer Pesel", true));
        pozycje.Add(new Pozycja("III", "Dane identyfikacyjne osoby zgłaszanej do ubezpieczeń", "p4", "4", "Numer paszport", true));
        pozycje.Add(new Pozycja("V", "Tytuł ubezpieczenia", "p1", "1", "Kod tytułu ubezpieczenia", true));
        pozycje.Add(new Pozycja("VI", "Dane o obowiązkowych ubezpieczeniach społecznych", "p1", "1", "Data powstania obowiązku ubezpieczeń", true));
        pozycje.Add(new Pozycja("VI", "Dane o obowiązkowych ubezpieczeniach społecznych", "p2", "2", "Osoba zgłaszana podlega ubezpieczeniu: Emerytalnemu", true));
        pozycje.Add(new Pozycja("VI", "Dane o obowiązkowych ubezpieczeniach społecznych", "p3", "3", "Osoba zgłaszana podlega ubezpieczeniu: Rentowym", true));
        pozycje.Add(new Pozycja("VI", "Dane o obowiązkowych ubezpieczeniach społecznych", "p4", "4", "Osoba zgłaszana podlega ubezpieczeniu: Chorobowemu", true));
        pozycje.Add(new Pozycja("VI", "Dane o obowiązkowych ubezpieczeniach społecznych", "p5", "5", "Osoba zgłaszana podlega ubezpieczeniu: Wypadkowemu", true));
        pozycje.Add(new Pozycja("VII", "Dane o obowiązkowym ubezpieczeniu zdrowotnym", "p1", "1", "Data powstania obowiązku ubezpieczenia", true));
        pozycje.Add(new Pozycja("VII", "Dane o obowiązkowym ubezpieczeniu zdrowotnym", "p2", "2", "Kod oddziału NFZ", true));
        pozycje.Add(new Pozycja("VIII", "Dane o dobrowolnych ubezpieczeniach społecznych", "p1", "1", "Osoba zgłaszana podlega ubezpieczeniu: Emerytalnemu", false));
        pozycje.Add(new Pozycja("VIII", "Dane o dobrowolnych ubezpieczeniach społecznych", "p2", "2", "Data rozpoczęcia ubezpieczenia emerytalnego", false));
        pozycje.Add(new Pozycja("VIII", "Dane o dobrowolnych ubezpieczeniach społecznych", "p3", "3", "Osoba zgłaszana podlega ubezpieczeniu: Rentowym", false));
        pozycje.Add(new Pozycja("VIII", "Dane o dobrowolnych ubezpieczeniach społecznych", "p4", "4", "Data rozpoczęcia ubezpieczenia rentowego", false));
        pozycje.Add(new Pozycja("VIII", "Dane o dobrowolnych ubezpieczeniach społecznych", "p5", "5", "Osoba zgłaszana podlega ubezpieczeniu: Chorobowemu", false));
        pozycje.Add(new Pozycja("VIII", "Dane o dobrowolnych ubezpieczeniach społecznych", "p6", "6", "Data rozpoczęcia ubezpieczenia chorobowego", false));
        pozycje.Add(new Pozycja("IX", "Dane o dobrowolnym ubezpieczeniu zdrowotnym", "p1", "1", "Data rozpoczęcia ubezpieczenia", false));
        pozycje.Add(new Pozycja("IX", "Dane o dobrowolnym ubezpieczeniu zdrowotnym", "p2", "2", "Kod oddziału NFZ", false));

        string wartosc = "";
        string p31 = "", p34 = "";
        foreach (Soneta.Deklaracje.DefinicjaBloku defBlok in zua.Bloki)
            foreach (Soneta.Deklaracje.DefinicjaPola defPole in defBlok.Pola)
                foreach (Pozycja pz in pozycje)
                    if (pz.Porownaj(defBlok.XmlTag, defPole.XmlTag)) {
                        wartosc = defPole.GetValue(zua).ToString();
                        switch (defPole.Typ) {
                            case TypPolaDeklaracji.Bool:
                            case TypPolaDeklaracji.Int:
                                if (wartosc.ToLower() == "true")
                                    wartosc = "TAK";
                                else if (wartosc.ToLower() == "false")
                                    wartosc = "NIE";
                                break;
                        }
                        pz.Przypisz(wartosc);
                        if (pz.Blok == "III" && pz.Numer == "1")
                            p31 = wartosc;
                        else if (pz.Blok == "III" && pz.Numer == "4")
                            p34 = wartosc;
                        break;
                    }

        if (p31.Length > 0 || p34.Length > 0)
            foreach (Pozycja pz in pozycje)
                if (pz.Blok == "III" && (pz.Numer == "1" || pz.Numer == "4") && pz.Wartosc == empty)
                    pz.Wartosc = "";

        Grid1.DataSource = pozycje;
    }

    void DekZWUA(Deklaracja dek) {
        Soneta.Deklaracje.ZUS.ZWUA zwua = (Soneta.Deklaracje.ZUS.ZWUA)dek;
        Symbol.EditValue = "ZWUA";
        Pracownik.EditValue = zwua.Pracownik;
        
        List<Pozycja> pozycje = new List<Pozycja>();
        pozycje.Add(new Pozycja("III", "Dane identyfikacyjne osoby wyrejestrowanej z ubezpieczeń", "p1", "1", "Numer Pesel", true));
        pozycje.Add(new Pozycja("III", "Dane identyfikacyjne osoby wyrejestrowanej z ubezpieczeń", "p4", "4", "Numer paszport", true));
        pozycje.Add(new Pozycja("IV", "Wyrejestrowanie z ubezpieczeń", "p1", "1", "Kod tytułu ubezpieczenia", true));
        pozycje.Add(new Pozycja("IV", "Wyrejestrowanie z ubezpieczeń", "p2", "2", "Wyrejestrowanie z ubezpieczeń od dnia", true));
        pozycje.Add(new Pozycja("IV", "Wyrejestrowanie z ubezpieczeń", "p3", "3", "Kod przyczyny wyrejestrowania", true));

        string wartosc = "";
        string p31 = "", p34 = "";
        foreach (Soneta.Deklaracje.DefinicjaBloku defBlok in zwua.Bloki)
            foreach (Soneta.Deklaracje.DefinicjaPola defPole in defBlok.Pola)
                foreach (Pozycja pz in pozycje)
                    if (pz.Porownaj(defBlok.XmlTag, defPole.XmlTag)) {
                        wartosc = defPole.GetValue(zwua).ToString();
                        switch (defPole.Typ) {
                            case TypPolaDeklaracji.Bool:
                            case TypPolaDeklaracji.Int:
                                if (wartosc.ToLower() == "true")
                                    wartosc = "TAK";
                                else if (wartosc.ToLower() == "false")
                                    wartosc = "NIE";
                                break;
                        }
                        pz.Przypisz(wartosc);
                        if (pz.Blok == "III" && pz.Numer == "1")
                            p31 = wartosc;
                        else if (pz.Blok == "III" && pz.Numer == "4")
                            p34 = wartosc;
                        break;
                    }

        if (p31.Length > 0 || p34.Length > 0)
            foreach (Pozycja pz in pozycje)
                if (pz.Blok == "III" && (pz.Numer == "1" || pz.Numer == "4") && pz.Wartosc == empty)
                    pz.Wartosc = "";

        Grid1.DataSource = pozycje;
    }

    void DekZZA(Deklaracja dek) {
        Soneta.Deklaracje.ZUS.ZZA zza = (Soneta.Deklaracje.ZUS.ZZA)dek;
        Symbol.EditValue = "ZZA";
        Pracownik.EditValue = zza.Pracownik;
        
        List<Pozycja> pozycje = new List<Pozycja>();
        pozycje.Add(new Pozycja("III", "Dane identyfikacyjne osoby zgłaszanej do ubezpieczenia", "p1", "1", "Numer Pesel", true));
        pozycje.Add(new Pozycja("III", "Dane identyfikacyjne osoby zgłaszanej do ubezpieczenia", "p4", "4", "Numer paszport", true));
        pozycje.Add(new Pozycja("V", "Tytuł ubezpieczenia", "p1", "1", "Kod tytułu ubezpieczenia", true));
        pozycje.Add(new Pozycja("VI", "Dane o obowiązkowym ubezpieczeniu zdrowotnym", "p1", "1", "Data powstania obowiązku ubezpieczenia", true));
        pozycje.Add(new Pozycja("VI", "Dane o obowiązkowym ubezpieczeniu zdrowotnym", "p2", "2", "Kod oddziału NFZ", true));

        string wartosc = "";
        string p31 = "", p34 = "";
        foreach (Soneta.Deklaracje.DefinicjaBloku defBlok in zza.Bloki)
            foreach (Soneta.Deklaracje.DefinicjaPola defPole in defBlok.Pola)
                foreach (Pozycja pz in pozycje)
                    if (pz.Porownaj(defBlok.XmlTag, defPole.XmlTag)) {
                        wartosc = defPole.GetValue(zza).ToString();
                        switch (defPole.Typ) {
                            case TypPolaDeklaracji.Bool:
                            case TypPolaDeklaracji.Int:
                                if (wartosc.ToLower() == "true")
                                    wartosc = "TAK";
                                else if (wartosc.ToLower() == "false")
                                    wartosc = "NIE";
                                break;
                        }
                        pz.Przypisz(wartosc);
                        if (pz.Blok == "III" && pz.Numer == "1")
                            p31 = wartosc;
                        else if (pz.Blok == "III" && pz.Numer == "4")
                            p34 = wartosc;
                        break;
                    }

        if (p31.Length > 0 || p34.Length > 0)
            foreach (Pozycja pz in pozycje)
                if (pz.Blok == "III" && (pz.Numer == "1" || pz.Numer == "4") && pz.Wartosc == empty)
                    pz.Wartosc = "";

        Grid1.DataSource = pozycje;
    }
    
    void Grid1_BeforeRow(Object sender, RowEventArgs args) {
        Pozycja pz = (Pozycja)args.Row;
        if (pars.Braki)
            args.VisibleRow = pz.Wartosc == empty;
    }    
    
</script>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Deklaracja ZZA</title> 
    <meta content="False" name="vs_showGrid" />
    <meta content="Microsoft Visual Studio 7.0" name="GENERATOR" />
    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
	</head>
	<BODY>
        <FORM id="DeklaracjaZZA" method="post" runat="server">
			<ea:DataContext id="dc" runat="server" oncontextload="OnContextLoad"></ea:DataContext>
            <eb:ReportHeader id="ReportHeader1" runat="server" title="Informacja zbiorcza"></eb:ReportHeader>
            <br />
            <ea:DataRepeater ID="DataRepeater1" runat="server" OnBeforeRow="DataRepeater1_BeforeRow">
    			<FONT face="Tahoma" size="2">
                    Symbol: <ea:DataLabel id="Symbol" runat="server"></ea:DataLabel>,
                    Podmiot: <ea:DataLabel id="Pracownik" runat="server"></ea:DataLabel>
	            </FONT>		    
                <ea:Grid id="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow" GroupLine="{0}. {1}" GroupData0="Blok" GroupData1="Tytul">
				    <Columns>
					    <ea:GridColumn runat="server" Align="Left" Caption="Pole" DataMember="Numer" Width="6"></ea:GridColumn>
					    <ea:GridColumn runat="server" Align="Left" Caption="Nazwa" DataMember="Opis"></ea:GridColumn>
					    <ea:GridColumn runat="server" Align="Left" Caption="Wartość" DataMember="Wartosc" Width="30"></ea:GridColumn>
				    </Columns>
			    </ea:Grid>
                <br />
            </ea:DataRepeater>
            <eb:ReportFooter id="ReportFooter1" runat="server"></eb:ReportFooter>
		</FORM>
	</BODY>
</html>
